/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.web.api.v1;

import java.util.LinkedList;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public record PathSegment(String segment, @Nullable PathSegment next) {
    public PathSegment(String segment, @Nullable PathSegment next) {
        if (segment.isEmpty() || segment.equals(".") || segment.contains("/")) {
            PathSegment from = Objects.requireNonNull(PathSegment.of(segment, next));
            this.segment = from.segment;
            this.next = from.next;
        } else {
            this.segment = segment;
            this.next = next;
        }
    }

    public PathSegment(String path) {
        this(path, null);
    }

    @Override
    public String toString() {
        return this.next == null ? this.segment : this.segment + "/" + String.valueOf(this.next);
    }

    public PathSegment concat(@Nullable PathSegment seg) {
        return seg == null ? this : new PathSegment(this.segment, this.next == null ? seg : this.next.concat(seg));
    }

    @Nullable
    public static PathSegment concat(@Nullable PathSegment seg1, @Nullable PathSegment seg2) {
        return seg1 == null ? seg2 : seg1.concat(seg2);
    }

    @Nullable
    public static PathSegment of(String path) {
        return PathSegment.of(path, null);
    }

    @Nullable
    private static PathSegment of(String path, PathSegment next) {
        LinkedList<String> segmentStack = new LinkedList<String>();
        for (String s : path.split("/")) {
            if (s.isEmpty() || s.equals(".")) continue;
            if (s.equals("..")) {
                segmentStack.pop();
            }
            segmentStack.push(s);
        }
        for (String s : segmentStack) {
            next = new PathSegment(s, next);
        }
        return next;
    }
}

